clear all;
load regression_data_brookings.mat;
nobs=60;

baacomp107=data(:,3);
baaaaa107=data(:,4);
lnmarketgdp1=data(:,5);
market10yeq=data(:,6);
ln10yeqgdp=data(:,7);
svw107=data(:,8);
slope1107=data(:,9);
debtgdp=exp(lnmarketgdp1);

%y=baacomp107;
y=baaaaa107;

x=[ones(nobs,1) ln10yeqgdp slope1107 svw107]; 
z=[ones(nobs,1) debtgdp (debtgdp).^2 (debtgdp).^3 slope1107 svw107];

w=z*inv(z'*z)*z'*x;
biv=inv(w'*x)*(w'*y);

% Standard errors using AR(1) assumption;

eps=y-x*biv;
epslag=zeros(nobs,1);

t=2;
    while t<=nobs;
        epslag(t)=eps(t-1);
        t=t+1;
    end;
 epsx=eps(2:nobs);
 epslagx=epslag(2:nobs);

 m=[ones(nobs-1,1) epslagx];
 phix=inv(m'*m)*m'*epsx;
 phi=phix(2);
 
 rho=zeros(nobs,1);
 rho(1)=phi(1);
 rho(2)=phi(1)*rho(1);
 i=3;
 while i<=nobs;
     rho(i)=phi(1)*rho(i-1);     
     i=i+1;
 end;
  
 sig2e=var(eps);
 sig2u=var(epsx-m*phix);
 gam0=sig2u/((1-phi(1)^2));
  
sumR=zeros(4,4);
 
 lag=1;
 while lag<=nobs-1;
    R=zeros(4,4); 
    t=lag+1;
    while t<=nobs;       
        R=R+(1/(nobs-lag))*w(t,:)'*w(t-lag,:);
        t=t+1;
    end;
    sumR=sumR+gam0*(rho(lag))*(R+R');

lag=lag+1;
end;

V=(1/nobs)*gam0*w'*w+sumR;

Qwx=w'*x/nobs;
Viv_ar=(1/nobs)*inv(Qwx)'*V*inv(Qwx);
tiv_ar=[biv(1)/sqrt(Viv_ar(1,1)) biv(2)/sqrt(Viv_ar(2,2)) biv(3)/sqrt(Viv_ar(3,3)) biv(4)/sqrt(Viv_ar(4,4))];

[biv';tiv_ar]

